@extends('layouts.app')
@section('title', __('lang_v1.list_offers'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>@lang( 'lang_v1.list_offers' )
    </h1>
    
</section>

<!-- Main content -->
<section class="content">

	<div class="box">
        <div class="box-header">
        	<h3 class="box-title">@lang('lang_v1.all_your_offer')</h3>
            @can('offer.create')
            	<div class="box-tools">
                    <a class="btn btn-block btn-primary" href="{{action([\App\Http\Controllers\OfferController::class, 'create'])}}">
                        <i class="fa fa-plus"></i> @lang( 'messages.add' )
                    </a>
                </div>
            @endcan
        </div>
        <div class="box-body">
            @can('offer.view')
                <div class="table-responsive">
            	<table class="table table-bordered table-striped" id="offers_table">
            		<thead>
            			<tr>
                            <th><input type="checkbox" id="select-all-row" data-table-id="offers_table"></th>
            				<th>@lang( 'unit.name' )</th>
                            <th>@lang( 'lang_v1.offer_type' )</th>
            				<th>Starte Date</th>
            				<th>End Date</th>
                            <th>@lang( 'lang_v1.status' )</th>
                            <th>@lang( 'messages.action' )</th>
            			</tr>
            		</thead>
                    <tfoot>
                    <tr>
                        <td colspan="11">
                        <div style="display: flex; width: 100%;">
                            {!! Form::open(['url' => action([\App\Http\Controllers\OfferController::class, 'massDeactivate']), 'method' => 'post', 'id' => 'mass_deactivate_form' ]) !!}
                            {!! Form::hidden('selected_offers', null, ['id' => 'selected_offers']); !!}
                            {!! Form::submit(__('lang_v1.deactivate_selected'), array('class' => 'btn btn-xs btn-warning', 'id' => 'deactivate-selected')) !!}
                            {!! Form::close() !!}
                            </div>
                        </td>
                    </tr>
                </tfoot>
            	</table>
                </div>
            @endcan
        </div>
    </div>

</section>
<!-- /.content -->
@stop
@section('javascript')
<script type="text/javascript">
    $(document).on('click', '#deactivate-selected', function(e){
        e.preventDefault();
        var selected_rows = [];
        var i = 0;
        $('.row-select:checked').each(function () {
            selected_rows[i++] = $(this).val();
        }); 
        
        if(selected_rows.length > 0){
            $('input#selected_offers').val(selected_rows);
            swal({
                title: LANG.sure,
                icon: "warning",
                buttons: true,
                dangerMode: true,
            }).then((willDelete) => {
                if (willDelete) {
                    $('form#mass_deactivate_form').submit();
                }
            });
        } else{
            $('input#selected_offers').val('');
            swal('@lang("lang_v1.no_row_selected")');
        }    
    });

    $(document).on('click', '.activate-offer', function(e){
        e.preventDefault();
        var href = $(this).data('href');
        $.ajax({
            method: "get",
            url: href,
            dataType: "json",
            success: function(result){
                if(result.success == true){
                    toastr.success(result.msg);
                    offers_table.ajax.reload();
                } else {
                    toastr.error(result.msg);
                }
            }
        });
    });

    $(document).on('change', '#variation_ids', function(){
        if ($(this).val().length) {
            $('#brand_input').addClass('hide');
            $('#category_input').addClass('hide');
        } else {
            $('#brand_input').removeClass('hide');
            $('#category_input').removeClass('hide');
        }
    });
</script>
@endsection
