@extends('layouts.app')
@section('title', __('lang_v1.add_offer'))
@section('content')
<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>@lang( 'lang_v1.add_offer' )</h1>
</section>
<!-- Main content -->
<style>
  #divStore {
    display: none;
  }
  select,
.select2-container { 
  width: 100% !important;
}
.select2-selection__clear {
  z-index: 9999
}
</style>
<section class="content">
	<div class="box">
        <div class="box-header">
        	<h3 class="box-title">@lang('lang_v1.offer_on_amount')</h3>
            @can('offer.create')
            	<div class="box-tools">
                    <a class="btn btn-block btn-primary" href="{{action([\App\Http\Controllers\OfferController::class, 'create'])}}">
                        <i class="fa fa-plus"></i> @lang( 'messages.add' )
                    </a>
                </div>
            @endcan
        </div>
        <div class="box-body">
            @can('offer.create')
            <div class="row">
              <div class="col-md-6">
                <div class="form-group">
                  {!! Form::label('offer_type', __( 'lang_v1.select_offer_type' ) . ':*') !!}
                  {!! Form::select('offer_type', [''=> 'Select Offer Type', '1'=> 'Individual Item', '2'=> 'Bill Amount', '3' => 'Based On Qty' ], isset($offer_type) ? $offer_type : '', ['onchange' => 'javascript:onChange(this.value)', 'class' => 'form-control select2', 'id' => 'unit_id']); !!}
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  {!! Form::label('calculation_type', 'Calculation Method:*') !!}
                  {!! Form::select('calculation_type', ['1'=> 'General', '2'=> 'Advance'], old('calculation_type'), ['class' => 'form-control select2', 'id' => 'calculation_type']); !!}
                  <p class="help-block text-small">For General Example : 100x11/100 = 11.00, For Advance Example : 100/1.11 = 90.09</p>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  {!! Form::label('offer_for', 'Offer For:*') !!}
                  {!! Form::select('offer_for', ['' => 'Select offer for','1'=> 'All Stores', '2'=> 'Specific Store'], old('offer_for'), ['onchange' => "javascript:($(this).val() == 2) ? $('#divStore').show() : $('#divStore').hide();", 'class' => 'form-control select2', 'id' => 'offer_for']); !!}
                </div>
              </div>
              <div class="col-md-6" id="divStore">
                <div class="form-group">
                  {!! Form::label('location_id', 'Store Name:*') !!}
                  {!! Form::select('location_id', $locations, null, ['placeholder' => __('messages.please_select'), 'class' => 'form-control select2']); !!}
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  {!! Form::label('name', 'Offer Name:*') !!}
                    {!! Form::text('name', null, ['class' => 'form-control', 'required', 'placeholder' => 'Name' ]); !!}
                </div>
              </div>
              <div class="clearfix"></div>
              <div class="col-md-4">
                <div class="form-group">
                  {!! Form::label('min_purchase', 'Min Purchase:*') !!}
                  {!! Form::text('min_purchase[]', null, ['id' =>'min_purchase', 'placeholder' => 'Min Purchase','class' => 'form-control input_number', 'required' ]); !!}
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group">
                  {!! Form::label('max_purchase', 'Max Purchase:*') !!}
                  {!! Form::text('max_purchase[]', null, ['id' =>'max_purchase','placeholder' => 'Max Purchase','class' => 'form-control input_number ', 'required' ]); !!}
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group">
                  {!! Form::label('discount', 'Discount:*') !!}
                  {!! Form::text('discount[]', null, ['id' =>'discount','class' => 'form-control input_number', 'required', 'placeholder' => 'Discount' ]); !!}
                </div>
              </div>
              <div class="col-md-12">
                <div class="form-group">
                  <button type="button" class="btn btn-primary btn-sm" id="addCF">Add This</button>
                </div>
              </div>
              <div class="col-md-12">
                <table class="table table-striped" id="qty_table" style="display: none">
                  <thead>
                    <tr>
                        <th scope="col-md-3">Min Purchase</th>
                        <th scope="col-md-3">Max Purchase</th>
                        <th scope="col-md-3">Discount</th>
                        <th scope="col-md-3">Delete</th>
                    </tr>
                  </thead>
                    <tbody>
                      
                    </tbody>
                  </table>
                </div>
              <div class="clearfix"></div>
              <div class="col-md-4">
                <div class="form-group">
                  {!! Form::label('offer_start_date', 'Offers Start Date:*') !!}
                  {!! Form::text('offer_start_date', null, ['class' => 'form-control', 'required', 'placeholder' => __( 'lang_v1.starts_at' ), 'readonly' ]); !!}
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group">
                  {!! Form::label('offer_end_date', 'Offers End Date:*') !!}
                  {!! Form::text('offer_end_date', null, ['class' => 'form-control', 'required', 'placeholder' => __( 'lang_v1.ends_at' ), 'readonly' ]); !!}
                </div>
              </div>
              <div class="col-sm-4">
                <div class="form-group">
                   {!! Form::label('status', 'Status') !!}<br>
                    {!! Form::checkbox('status', 1, true, ['class' => 'input-icheck']); !!} <strong>@lang('lang_v1.is_active')</strong>
                  </label>
                </div>
              </div>
            </div>
            <button type="submit" class="btn btn-primary">@lang( 'messages.save' )</button>
              @endcan
            </div>
        </div>
    </section>
    <!-- /.content -->
    @stop
    @section('javascript')
    <script>
      $(document).ready(function () { 
          
          $("#addCF").click(function(){ 
            
            var minqty = $("#min_purchase").val();
            var maxqty = $("#max_purchase").val();
            var discount = $("#discount").val();
            if (minqty == '' || maxqty == '' || discount == '') {
              alert('Pleas enter purchase details');
              return false;
            }
            $("#qty_table").show();
            var add = '<tr><td><input type="text" class="form-control input_number" name="min_purchase[]" value=" ' + minqty + '" placeholder="Min Purchase" required></td>';
              add += '<td><input type="text" class="form-control input_number" name="max_purchase[]" value="' + maxqty + '" placeholder="Max Purchase" required></td>';
              add += '<td><input type="text" class="form-control input_number" name="discount[]" value="' + discount + '" placeholder="Discount" required></td>';
              add += '<td><a href="javascript:void(0);" class="remCF"><i class="fa fa-times" style="font-size:20px;color:red"></i></a></td></tr>';
            $("#qty_table").append(add); 
            $("#min_purchase").val('');
            $("#max_purchase").val('');
            $("#discount").val('');
          });
      
          $("#qty_table").on('click','.remCF',function(){
              var inx = $('.remCF').index(this);
              $('tr').eq(inx+1).remove();
          });
          $('#variation_ids').select2({
            ajax: {
                url: '/purchases/get_products?check_enable_stock=false&only_variations=true',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    var results = [];
                    for (var item in data) {
                        results.push(
                            {
                                id: data[item].variation_id,
                                text: data[item].text,
                            }
                        );
                    }
                    return {
                        results: results,
                    };
                },
            },
            minimumInputLength: 1,
            closeOnSelect: true,
            placeholder: 'Select item',
            allowClear: true,
        });
        $("#variation_ids").val('').trigger('change')
      });
      $('#offer_end_date').datetimepicker({
        format: moment_date_format,
        minDate: new Date(),
        ignoreReadonly: true,
      });
      $('#offer_start_date').datetimepicker({
        format: moment_date_format,
        ignoreReadonly: true,
        minDate: new Date()
      });
      function onChange(e) {
        if(e == 1) { 
          window.location.href="{{ action('\App\Http\Controllers\OfferController@create', ['type' => 1]) }}";
        }
        if(e == 2) {
          window.location.href="{{ action('\App\Http\Controllers\OfferController@create', ['type' => 2]) }}";
        }
        if(e == 3) { 
          window.location.href="{{ action('\App\Http\Controllers\OfferController@create', ['type' => 3]) }}";
        }
      }
    </script>
@endsection