@extends('layouts.app')
@section('title', __('lang_v1.add_offer'))
@section('content')
<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>@lang( 'lang_v1.add_offer' )</h1>
</section>
<!-- Main content -->
<section class="content">
	<div class="box">
        <div class="box-header">
        	<h3 class="box-title">@lang('lang_v1.add_offer')</h3>
            @can('offer.create')
            	<div class="box-tools">
                    <a class="btn btn-block btn-primary" href="{{action([\App\Http\Controllers\OfferController::class, 'create'])}}">
                        <i class="fa fa-plus"></i> @lang( 'messages.add' )
                    </a>
                </div>
            @endcan
        </div>
        <div class="box-body">
            @can('offer.view')
            <div class="row">
              <div class="col-md-12">
                <div class="form-group">
                  {!! Form::label('offer_type', __( 'lang_v1.select_offer_type' ) . ':*') !!}<br>
                  {!! Form::select('offer_type', [''=> 'Select Offer Type', '1'=> 'Individual Item', '2'=> 'Bill Amount', '3' => 'Based On Qty' ], '', ['onchange' => 'javascript:onChange(this.value)', 'class' => 'form-control select2', 'style' => 'width:40%;', 'id' => 'unit_id']); !!}
                </div>
              </div>
            </div>
            @endcan
        </div>
    </div>
</section>
<!-- /.content -->
@stop
@section('javascript')
<script>   
  function onChange(e) {
    if(e == 1) { 
      window.location.href="{{ action('\App\Http\Controllers\OfferController@create', ['type' => 1]) }}";
    }
    if(e == 2) {
      window.location.href="{{ action('\App\Http\Controllers\OfferController@create', ['type' => 2]) }}";
    }
    if(e == 3) { 
      window.location.href="{{ action('\App\Http\Controllers\OfferController@create', ['type' => 3]) }}";
    }
  }
</script>
@endsection
